#ifndef ENGINEERINGMODE_H
#define ENGINEERINGMODE_H

#define	dOpenLoop	1
#define	dCloseLoop	2

// <<< Use Configuration Wizard in Context Menu >>>
	// <o> SOP_LEVEL <1=> OpenLoop <2=> CloseLoop
		// <i> OpenLoop (Note : Fine tune smo parameters. After operation, you need to manually switch CloseLoopFlag)
		// <i> CloseLoop(Note : Automatically switch CloseLoopFlag after operation)
			#define SOP_LEVEL 	2	
// <h> OpenLoop Ѽ 
	// <o> Set IQ parking duration(unit : ms)
	#define IQ_PARKING_TIME 600
	
	#if ((SOP_LEVEL == dOpenLoop) || (SOP_LEVEL == dCloseLoop))
	#define SMO_PLL_INI_SPD (float)0 * 32767 / (BASE_RPM)    // unit : Rpm
	
	// <o> Set speed ratio for closeloop (unit : 0-100%)
	// <i> Ratio of Motor rated maxinum speed(0-100%)
	#define SMO_PLL_END_SPD (uint16)((float)20.0 / 100 * RATED_SPEED * 32767 / (BASE_RPM))    // unit : Rpm
	#define SMO_PLL_MID_SPD (uint16)((float)2.0 / 100 * RATED_SPEED * 32767 / (BASE_RPM))    // "SMO_PLL_MID_SPD" has to less than "SMO_PLL_END_SPD"
		
	// <o> Set PLL accumulation
	#define PLL_ACC 3
	
	// <o> Set SMO_RAMP acceleration slope (unit : ms) <0-10000> 
	#define SMO_RAMP 15
	#endif

	// <o> Set SMO_DELAY Delay time (unit : ms) <0-65535>
	#define SMO_DELAY_DURATION 1
			
	// <h> Set IQ current ratio
		#define RATED_CURRENT (float)(WATT_MAX/VBUS)

		// <o> Set IQ start Current ratio(0-100%)
		// <i> RATED_CURRENT = (WATT_MAX/VBUS)
		// <i> (CUR_RATIO/100)*(WATT_MAX/VBUS)
		#define CUR_LOOP_PARKING_IQ (uint16)((float) 90.0 / 100 * RATED_CURRENT * I_AMPLIFIER / 1000) // unit : A * Gain
		// <o> Set IQ end Current ratio(0-100%)
		#define CUR_LOOP_END_IQ (uint16)((float) 60.0 / 100 * RATED_CURRENT * I_AMPLIFIER / 1000) // unit : A * Gain
			
		#define IQ_PARKING_RANK 		IQ_PARKING_TIME	//ijIQ_PARKING_TIME
		#define IQ_PARKING_CUR_STEP (CUR_LOOP_PARKING_IQ/IQ_PARKING_RANK)
		#define IQ_PARKING_TIME_STEP (IQ_PARKING_TIME/IQ_PARKING_RANK)
	// </h>
	
	// <h> Set ID Current parameter
		// <o> Set ID Starting current (unit : mA)
		#define ID_FIRST_START_VALUE (int16)((float) -0/1000 * I_AMPLIFIER) // unit : A * Gain

		// <o> Set ID End current (unit : mA)
		#define ID_FINAL_START_VALUE (int16)((float) -0/1000 * I_AMPLIFIER) // unit : A * Gain
	// </h>
// </h>

// <h> CloseLoop Ѽ
	// <q> User-adjusted KP/KI
		#define user_KP_KI	0
	
	// <h> Set IQ PI parameters
		// <o> IQ's Kp
			#define Cur_Kp_user 	600

		// <o> IQ's Ki
			#define Cur_Ki_user 	20
	// </h>
	
	// <h> Set SPEED PI parameters
		// <o> Start Kp parameters <0-32767>
			#define Spd_Kp_Start 	0
				
		// <o> Final Kp parameters <0-32767>
			#define Spd_Kp_Final 	2000
				
		// <o> Ki parameters <0-32767>
			#define Spd_Ki 			50

		// <o> MaxLimit parameters (unit : mA)) <0-32767>
			#define Spd_MaxLimit 	(int16)((float) 1000/1000 * I_AMPLIFIER)

		// <o> MinLimit parameters (unit : mA) <0-32767>
			#define Spd_MinLimit 	(int16)((float) -0/1000 * I_AMPLIFIER)
	// </h>

	// <h> Set PLL PI parameters
		// <o> Start Kp parameters <0-32767>
			#define Pll_Kp_Start 	10000
				
		// <o> Pll's Kp
			#define Pll_Kp_user  	25000				
				
		// <o> Pll's Ki
			#define Pll_Ki_user 	62							
	// </h>
// </h>

//<h> set Limit for parameters
	// <h> Set IQ PI parameters
		// <o> Kt parameters <0-32767>
		#define Iq_Kt 	32767
				
		// <o> MaxLimit parameters <0-32767>
		#define Iq_MaxLimit 32767
				
		// <o> MinLimit parameters <0-32767>
		#define Iq_MinLimit -32767
	// </h>
	
	// <h> Set ID PI parameters

		// <o> Kt parameters <0-32767>
			#define Id_Kt 32767
				
		// <o> MaxLimit parameters <0-32767>
			#define Id_MaxLimit 32767
				
		// <o> MinLimit parameters <0-32767>
			#define Id_MinLimit -32767
	// </h>

	// <h> Set SPEED PI parameters

		// <o> Kt parameters <0-32767>
			#define Spd_Kt 		32767
	// </h>
			
	// <h> Set PLL PI parameters

		// <o> Kt parameters <0-32767>
			#define Pll_Kt 32767
				
		// <o> MaxLimit parameters <0-32767>
			#define Pll_MaxLimit 32767
				
		// <o> MinLimit parameters <0-32767>
			#define Pll_MinLimit -32767
	// </h>


	// <h> Set PLL PI parameters
		//<o> Motor SMO_Z-Corr <0-32767>
			#define ZCorr 32767

		//<o> Motor SMO_BanGain (Sat) <0-32767>
			#define BanGain 32767

		//<o> Motor SMO_MaxSmcError (Limit) <0-32767>
			#define MaxSmcError 9000
	//</h>
//</h>
// <<< end of configuration section >>>

#endif
